;copywrite 2001 by Samuel Stearley


	include	"os.h"


	xdef		_ti89
	xdef		_ti92plus
	xdef		_nostub



;The following macro is called debug.  It sets the carry flag and then enters the
;loop, which will of course continue for all eternity because the carry will not
;change.  This gives me time to right click on vti and select "enter debugger."
;Once in the debugger I will manually unset the carry flag.  Then I can single
;step through the program.



debug MACRO

	move	#1,ccr
\loop:
	bcs	\loop

	ENDM	


;---First thing to do is to find the pointer to the flag that tells me if
;---the cursor is in the entry line.  And then put it into code.


	movem.l	d3-d7/a2-a6,-(a7)
	move.l	a7,d7				;save stack pointer
	move.l	200,a6			;pointer to the jump table
	move.l	1080(a6),a0			;get pointer to the code of home execute call
	move.l	708(a6),d0			;get pointer to te_select- will search
							;  for this value in the code of the home execute
							;  call
search_loop:
	addq.l	#2,a0				;code is alligned on words
	cmp.l		(a0),d0			;is it the place to jsr too?
	bne.s		search_loop
	move.w	-4(a0),d0			;now got pointer to the tios entyline text edit
							;  structure.
	add.w		#16,d0			;pointer to word that tells if anything has
							;  been entered.
	lea		tst_opcode2+2(pc),a0
	move.w	d0,(a0)

	add.w		#16,d0			;point it to the flag

	lea		btst_opcode+4(pc),a0	;point to adress operand
	move.w	d0,(a0)			;move it into the ram


;---The Second thing to do is to get the pointer to the first window
;---and install it into my code

	move.l	824(a6),a0		;get send event call
	pea		event(pc)
	move.w	#-2,-(a7)		;current app
	jsr		(a0)

	move.l	(a6),a0		;get pointer to the first window pointer
	move.l	(a0),a0		;now get a pointer to the first window
	addq.w	#1,a0			;so it points to the byte with the active flag
	lea		tst_opcode1+2(pc),a1;get pointer to operand part
	move.w	a0,(a1)		;move it into my code


;---SO NOW INSTALL MY EVENT HOOK----


	move.l	2700(a6),a5			;got pointer to old evhook
	lea		old_event(pc),a1		;get pointer to the save space
	move.l	(a5),(a1)			;save it

	move.l	#END_OF_HOOK-BEGINNING_OF_HOOK,d3	;amount of ram needed
	move.l	d3,-(a7)			;ram needed to copy code too
	move.l	584(a6),a0			;get heap allocate high call
	jsr		(a0)				;allocate it -d0 has the handle
	pea		error_message
	tst.w		d0				;check for success
	beq.s		memory_error
	move.w	d0,-(a7)			;push for dereferencing
	move.l	600(a6),a0			;get dereference call -ao points to allocated memory
	jsr		(a0)
	move.l	a0,a1				;save a quick copy
	add.l		#$40010,a0			;increase the first to bypass hw2 protection
	move.l	a0,(a5)			;overwrite old event handler
	subq.l	#1,d3				;for dbra
	lea		BEGINNING_OF_HOOK(pc),a0
copy_loop:
	move.b	(a0)+,(a1)+
	dbra		d3,copy_loop		;copy over the handler
	pea		message(pc)

memory_error:
	move.l	920(a6),a0			;help displag call
	jsr		(a0)

;---Restore Registers and exit the installation-----


final:
	move.l	d7,a7				;reset the stack
	movem.l	(a7)+,d3-d7/a2-a6		;get registers back
	rts

;------------------------------------------------------
;AND NOW THE STRINGS AND DATA OF THE INSTALLATION PART
;------------------------------------------------------

message:		dc.b		"Answer + = Samuel Stearley (C) 2001",0
error_message:	dc.b		"Error: Not enough Memory",0

	EVEN	

event:
	dc.w		$710			;keypress event
	dc.w		0			;sender 		-will be filled by send event
	dc.w		0			;side is 0		-will be filled by send event
	dc.w		0			;status flags	-will be filled by send event
	dc.w		0
	dc.w		4360			;quit ekeypress

	EVEN		

;----------------------------------------------
;AND NOW FOR THE CODE OF THE HOOK
;----------------------------------------------

BEGINNING_OF_HOOK:
		dc.b	"evHkAns+eqal"	;signature and name
old_event:	dc.l	0			;space for the old event



;----First check the event type and if the home
;----application is active.

	move.l	4(a7),a2			;get pointer to the event structure
	cmp.w		#$710,(a2)			;is it command keypress
	bne.s		pass_it_on
tst_opcode1:
	tst.b		$1234				;garbage for the pointer to the first window
	bpl.s		pass_it_on			;if it is not on the home screen then I do nothing
btst_opcode:
	btst.b	#1,$1234			;garbage for the pointer to the cursor on the entry
							;  line flag.
	beq.s		pass_it_on			;if on the entry line then do nothing

	cmp.w		#61,10(a2)			;is it a with modifier
	bne.s		pass_it_on			;

tst_opcode2:
	tst.w		$1234				;will tell if ans is needed
	bne.s		pass_it_on			;

;----Now to add the answer plus the with tag.  The following code is taken
;----from extrakeys by Kevin Kofler for language localization purposes.

	movem.l	a3/a6/d7,-(a7)
	move.l	a7,d7			;save stack
	move.w	#$723,(a2)		;make it the paste text event
	lea		buffer(pc),a3
	move.l	a3,8(a2)		;put text buffer to the event structure
	move.l	200,a6
	move.l	#$1000b,-(a7)
	pea		ans1tag(PC)
	move.l	316(a6),a0		;get parse 1d call
	jsr		(a0)
	move.w	d0,-(a7)
	beq.s		only_with_operator
	move.l	600(a6),a0		;get heap derefernce
	jsr		(a0)
copy_ans:
	move.b	(a0),(a3)+
	cmp.b		#')',(a0)+
	bne.s		copy_ans
	move.l	604(a6),a0		;get heap free
	jsr		(a0)			

only_with_operator:

	move.b	#61,(a3)+		;place is the "|"
	clr.b		(a3)			;zero terminate
error:
	move.l	d7,a7			;reset stack
	movem.l	(a7)+,a3/a6/d7

;-----Code to call the next hook if there is one----------

pass_it_on:
	move.l	old_event(pc),a0		;get the old event handler
	move.l	a0,d0				;test it
	beq.s		no_old_hook
	move.l	a2,-(a7)			;input for the event handler
	jsr		(a0)				;call the next event handler
	addq.l	#4,a7				;pop it off
no_old_hook:
	rts

		dc.b	$e5,$01,$01,$1f		;data use with the answer tag
ans1tag:	dc.b	$bc
buffer	ds.b	15

END_OF_HOOK:


	END	

